# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from enum import Enum
from .sdapiobject import SDAPIObject
from .sdapiobject import SDApiError
from .apiexception import APIException

class SDPluginStatus(Enum):
    """
    Enum representing the plugin status
    """
    """Plugin is loaded"""
    Loaded = 0
    """Plugin is not loaded"""
    Unloaded = 1
    """Plugin failed to load"""
    LoadFailed = 2

class SDPlugin(SDAPIObject):
    """
    A plugin
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDPlugin
        """
        super(SDPlugin, self).__init__(APIContext, handle, *args, **kwargs)

    def getName(self) -> str:
        """
        Returns the plugin name

        """
        outPluginName = ctypes.c_char_p()
        _res = self.mAPIContext.SDPlugin_getName(self.mHandle, ctypes.byref(outPluginName))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outPluginName.value.decode('utf-8') # type: ignore

    def getDirectory(self) -> str:
        """
        Returns the plugin directory

        """
        outPluginDir = ctypes.c_char_p()
        _res = self.mAPIContext.SDPlugin_getDirectory(self.mHandle, ctypes.byref(outPluginDir))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outPluginDir.value.decode('utf-8') # type: ignore

    def getStatus(self) -> SDPluginStatus:
        """
        Returns the status of the plugin

        """
        outPluginStatus = ctypes.c_int()
        _res = self.mAPIContext.SDPlugin_getStatus(self.mHandle, ctypes.byref(outPluginStatus))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return SDPluginStatus(outPluginStatus.value)

    def getLastErrorMessage(self) -> str:
        """
        Returns the last plugin error message

        """
        outErrorMessage = ctypes.c_char_p()
        _res = self.mAPIContext.SDPlugin_getLastErrorMessage(self.mHandle, ctypes.byref(outErrorMessage))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outErrorMessage.value.decode('utf-8') # type: ignore

